/**********************************************************************************
 *
 * @file    reg_pis.h
 * @brief   PIS Head File
 *
 * @date    07 July 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 July 2022    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_PIS_H__
#define __REG_PIS_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/****************** Bit definition for PIS_CH0_CON register ************************/

#define PIS_CH0_CON_LEVEL_POS   31U
#define PIS_CH0_CON_LEVEL_MSK   BIT(PIS_CH0_CON_LEVEL_POS)

#define PIS_CH0_CON_PULSE_POS   30U
#define PIS_CH0_CON_PULSE_MSK   BIT(PIS_CH0_CON_PULSE_POS)

#define PIS_CH0_CON_SYNCSEL_POSS    24U
#define PIS_CH0_CON_SYNCSEL_POSE    26U
#define PIS_CH0_CON_SYNCSEL_MSK BITS(PIS_CH0_CON_SYNCSEL_POSS,PIS_CH0_CON_SYNCSEL_POSE)

#define PIS_CH0_CON_TSCKS_POSS  18U
#define PIS_CH0_CON_TSCKS_POSE  19U
#define PIS_CH0_CON_TSCKS_MSK   BITS(PIS_CH0_CON_TSCKS_POSS,PIS_CH0_CON_TSCKS_POSE)

#define PIS_CH0_CON_EDGS_POSS   16U
#define PIS_CH0_CON_EDGS_POSE   17U
#define PIS_CH0_CON_EDGS_MSK    BITS(PIS_CH0_CON_EDGS_POSS,PIS_CH0_CON_EDGS_POSE)

#define PIS_CH0_CON_SRCS_POSS   8U
#define PIS_CH0_CON_SRCS_POSE   13U
#define PIS_CH0_CON_SRCS_MSK    BITS(PIS_CH0_CON_SRCS_POSS,PIS_CH0_CON_SRCS_POSE)

#define PIS_CH0_CON_MSIGS_POSS  0U
#define PIS_CH0_CON_MSIGS_POSE  3U
#define PIS_CH0_CON_MSIGS_MSK   BITS(PIS_CH0_CON_MSIGS_POSS,PIS_CH0_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH1_CON register ************************/

#define PIS_CH1_CON_LEVEL_POS   31U
#define PIS_CH1_CON_LEVEL_MSK   BIT(PIS_CH1_CON_LEVEL_POS)

#define PIS_CH1_CON_PULSE_POS   30U
#define PIS_CH1_CON_PULSE_MSK   BIT(PIS_CH1_CON_PULSE_POS)

#define PIS_CH1_CON_SYNCSEL_POSS    24U
#define PIS_CH1_CON_SYNCSEL_POSE    26U
#define PIS_CH1_CON_SYNCSEL_MSK BITS(PIS_CH1_CON_SYNCSEL_POSS,PIS_CH1_CON_SYNCSEL_POSE)

#define PIS_CH1_CON_TSCKS_POSS  18U
#define PIS_CH1_CON_TSCKS_POSE  19U
#define PIS_CH1_CON_TSCKS_MSK   BITS(PIS_CH1_CON_TSCKS_POSS,PIS_CH1_CON_TSCKS_POSE)

#define PIS_CH1_CON_EDGS_POSS   16U
#define PIS_CH1_CON_EDGS_POSE   17U
#define PIS_CH1_CON_EDGS_MSK    BITS(PIS_CH1_CON_EDGS_POSS,PIS_CH1_CON_EDGS_POSE)

#define PIS_CH1_CON_SRCS_POSS   8U
#define PIS_CH1_CON_SRCS_POSE   13U
#define PIS_CH1_CON_SRCS_MSK    BITS(PIS_CH1_CON_SRCS_POSS,PIS_CH1_CON_SRCS_POSE)

#define PIS_CH1_CON_MSIGS_POSS  0U
#define PIS_CH1_CON_MSIGS_POSE  3U
#define PIS_CH1_CON_MSIGS_MSK   BITS(PIS_CH1_CON_MSIGS_POSS,PIS_CH1_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH2_CON register ************************/

#define PIS_CH2_CON_LEVEL_POS   31U
#define PIS_CH2_CON_LEVEL_MSK   BIT(PIS_CH2_CON_LEVEL_POS)

#define PIS_CH2_CON_PULSE_POS   30U
#define PIS_CH2_CON_PULSE_MSK   BIT(PIS_CH2_CON_PULSE_POS)

#define PIS_CH2_CON_SYNCSEL_POSS    24U
#define PIS_CH2_CON_SYNCSEL_POSE    26U
#define PIS_CH2_CON_SYNCSEL_MSK BITS(PIS_CH2_CON_SYNCSEL_POSS,PIS_CH2_CON_SYNCSEL_POSE)

#define PIS_CH2_CON_TSCKS_POSS  18U
#define PIS_CH2_CON_TSCKS_POSE  19U
#define PIS_CH2_CON_TSCKS_MSK   BITS(PIS_CH2_CON_TSCKS_POSS,PIS_CH2_CON_TSCKS_POSE)

#define PIS_CH2_CON_EDGS_POSS   16U
#define PIS_CH2_CON_EDGS_POSE   17U
#define PIS_CH2_CON_EDGS_MSK    BITS(PIS_CH2_CON_EDGS_POSS,PIS_CH2_CON_EDGS_POSE)

#define PIS_CH2_CON_SRCS_POSS   8U
#define PIS_CH2_CON_SRCS_POSE   13U
#define PIS_CH2_CON_SRCS_MSK    BITS(PIS_CH2_CON_SRCS_POSS,PIS_CH2_CON_SRCS_POSE)

#define PIS_CH2_CON_MSIGS_POSS  0U
#define PIS_CH2_CON_MSIGS_POSE  3U
#define PIS_CH2_CON_MSIGS_MSK   BITS(PIS_CH2_CON_MSIGS_POSS,PIS_CH2_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH3_CON register ************************/

#define PIS_CH3_CON_LEVEL_POS   31U
#define PIS_CH3_CON_LEVEL_MSK   BIT(PIS_CH3_CON_LEVEL_POS)

#define PIS_CH3_CON_PULSE_POS   30U
#define PIS_CH3_CON_PULSE_MSK   BIT(PIS_CH3_CON_PULSE_POS)

#define PIS_CH3_CON_SYNCSEL_POSS    24U
#define PIS_CH3_CON_SYNCSEL_POSE    26U
#define PIS_CH3_CON_SYNCSEL_MSK BITS(PIS_CH3_CON_SYNCSEL_POSS,PIS_CH3_CON_SYNCSEL_POSE)

#define PIS_CH3_CON_TSCKS_POSS  18U
#define PIS_CH3_CON_TSCKS_POSE  19U
#define PIS_CH3_CON_TSCKS_MSK   BITS(PIS_CH3_CON_TSCKS_POSS,PIS_CH3_CON_TSCKS_POSE)

#define PIS_CH3_CON_EDGS_POSS   16U
#define PIS_CH3_CON_EDGS_POSE   17U
#define PIS_CH3_CON_EDGS_MSK    BITS(PIS_CH3_CON_EDGS_POSS,PIS_CH3_CON_EDGS_POSE)

#define PIS_CH3_CON_SRCS_POSS   8U
#define PIS_CH3_CON_SRCS_POSE   13U
#define PIS_CH3_CON_SRCS_MSK    BITS(PIS_CH3_CON_SRCS_POSS,PIS_CH3_CON_SRCS_POSE)

#define PIS_CH3_CON_MSIGS_POSS  0U
#define PIS_CH3_CON_MSIGS_POSE  3U
#define PIS_CH3_CON_MSIGS_MSK   BITS(PIS_CH3_CON_MSIGS_POSS,PIS_CH3_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH4_CON register ************************/

#define PIS_CH4_CON_LEVEL_POS   31U
#define PIS_CH4_CON_LEVEL_MSK   BIT(PIS_CH4_CON_LEVEL_POS)

#define PIS_CH4_CON_PULSE_POS   30U
#define PIS_CH4_CON_PULSE_MSK   BIT(PIS_CH4_CON_PULSE_POS)

#define PIS_CH4_CON_SYNCSEL_POSS    24U
#define PIS_CH4_CON_SYNCSEL_POSE    26U
#define PIS_CH4_CON_SYNCSEL_MSK BITS(PIS_CH4_CON_SYNCSEL_POSS,PIS_CH4_CON_SYNCSEL_POSE)

#define PIS_CH4_CON_TSCKS_POSS  18U
#define PIS_CH4_CON_TSCKS_POSE  19U
#define PIS_CH4_CON_TSCKS_MSK   BITS(PIS_CH4_CON_TSCKS_POSS,PIS_CH4_CON_TSCKS_POSE)

#define PIS_CH4_CON_EDGS_POSS   16U
#define PIS_CH4_CON_EDGS_POSE   17U
#define PIS_CH4_CON_EDGS_MSK    BITS(PIS_CH4_CON_EDGS_POSS,PIS_CH4_CON_EDGS_POSE)

#define PIS_CH4_CON_SRCS_POSS   8U
#define PIS_CH4_CON_SRCS_POSE   13U
#define PIS_CH4_CON_SRCS_MSK    BITS(PIS_CH4_CON_SRCS_POSS,PIS_CH4_CON_SRCS_POSE)

#define PIS_CH4_CON_MSIGS_POSS  0U
#define PIS_CH4_CON_MSIGS_POSE  3U
#define PIS_CH4_CON_MSIGS_MSK   BITS(PIS_CH4_CON_MSIGS_POSS,PIS_CH4_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH5_CON register ************************/

#define PIS_CH5_CON_LEVEL_POS   31U
#define PIS_CH5_CON_LEVEL_MSK   BIT(PIS_CH5_CON_LEVEL_POS)

#define PIS_CH5_CON_PULSE_POS   30U
#define PIS_CH5_CON_PULSE_MSK   BIT(PIS_CH5_CON_PULSE_POS)

#define PIS_CH5_CON_SYNCSEL_POSS    24U
#define PIS_CH5_CON_SYNCSEL_POSE    26U
#define PIS_CH5_CON_SYNCSEL_MSK BITS(PIS_CH5_CON_SYNCSEL_POSS,PIS_CH5_CON_SYNCSEL_POSE)

#define PIS_CH5_CON_TSCKS_POSS  18U
#define PIS_CH5_CON_TSCKS_POSE  19U
#define PIS_CH5_CON_TSCKS_MSK   BITS(PIS_CH5_CON_TSCKS_POSS,PIS_CH5_CON_TSCKS_POSE)

#define PIS_CH5_CON_EDGS_POSS   16U
#define PIS_CH5_CON_EDGS_POSE   17U
#define PIS_CH5_CON_EDGS_MSK    BITS(PIS_CH5_CON_EDGS_POSS,PIS_CH5_CON_EDGS_POSE)

#define PIS_CH5_CON_SRCS_POSS   8U
#define PIS_CH5_CON_SRCS_POSE   13U
#define PIS_CH5_CON_SRCS_MSK    BITS(PIS_CH5_CON_SRCS_POSS,PIS_CH5_CON_SRCS_POSE)

#define PIS_CH5_CON_MSIGS_POSS  0U
#define PIS_CH5_CON_MSIGS_POSE  3U
#define PIS_CH5_CON_MSIGS_MSK   BITS(PIS_CH5_CON_MSIGS_POSS,PIS_CH5_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH6_CON register ************************/

#define PIS_CH6_CON_LEVEL_POS   31U
#define PIS_CH6_CON_LEVEL_MSK   BIT(PIS_CH6_CON_LEVEL_POS)

#define PIS_CH6_CON_PULSE_POS   30U
#define PIS_CH6_CON_PULSE_MSK   BIT(PIS_CH6_CON_PULSE_POS)

#define PIS_CH6_CON_SYNCSEL_POSS    24U
#define PIS_CH6_CON_SYNCSEL_POSE    26U
#define PIS_CH6_CON_SYNCSEL_MSK BITS(PIS_CH6_CON_SYNCSEL_POSS,PIS_CH6_CON_SYNCSEL_POSE)

#define PIS_CH6_CON_TSCKS_POSS  18U
#define PIS_CH6_CON_TSCKS_POSE  19U
#define PIS_CH6_CON_TSCKS_MSK   BITS(PIS_CH6_CON_TSCKS_POSS,PIS_CH6_CON_TSCKS_POSE)

#define PIS_CH6_CON_EDGS_POSS   16U
#define PIS_CH6_CON_EDGS_POSE   17U
#define PIS_CH6_CON_EDGS_MSK    BITS(PIS_CH6_CON_EDGS_POSS,PIS_CH6_CON_EDGS_POSE)

#define PIS_CH6_CON_SRCS_POSS   8U
#define PIS_CH6_CON_SRCS_POSE   13U
#define PIS_CH6_CON_SRCS_MSK    BITS(PIS_CH6_CON_SRCS_POSS,PIS_CH6_CON_SRCS_POSE)

#define PIS_CH6_CON_MSIGS_POSS  0U
#define PIS_CH6_CON_MSIGS_POSE  3U
#define PIS_CH6_CON_MSIGS_MSK   BITS(PIS_CH6_CON_MSIGS_POSS,PIS_CH6_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH7_CON register ************************/

#define PIS_CH7_CON_LEVEL_POS   31U
#define PIS_CH7_CON_LEVEL_MSK   BIT(PIS_CH7_CON_LEVEL_POS)

#define PIS_CH7_CON_PULSE_POS   30U
#define PIS_CH7_CON_PULSE_MSK   BIT(PIS_CH7_CON_PULSE_POS)

#define PIS_CH7_CON_SYNCSEL_POSS    24U
#define PIS_CH7_CON_SYNCSEL_POSE    26U
#define PIS_CH7_CON_SYNCSEL_MSK BITS(PIS_CH7_CON_SYNCSEL_POSS,PIS_CH7_CON_SYNCSEL_POSE)

#define PIS_CH7_CON_TSCKS_POSS  18U
#define PIS_CH7_CON_TSCKS_POSE  19U
#define PIS_CH7_CON_TSCKS_MSK   BITS(PIS_CH7_CON_TSCKS_POSS,PIS_CH7_CON_TSCKS_POSE)

#define PIS_CH7_CON_EDGS_POSS   16U
#define PIS_CH7_CON_EDGS_POSE   17U
#define PIS_CH7_CON_EDGS_MSK    BITS(PIS_CH7_CON_EDGS_POSS,PIS_CH7_CON_EDGS_POSE)

#define PIS_CH7_CON_SRCS_POSS   8U
#define PIS_CH7_CON_SRCS_POSE   13U
#define PIS_CH7_CON_SRCS_MSK    BITS(PIS_CH7_CON_SRCS_POSS,PIS_CH7_CON_SRCS_POSE)

#define PIS_CH7_CON_MSIGS_POSS  0U
#define PIS_CH7_CON_MSIGS_POSE  3U
#define PIS_CH7_CON_MSIGS_MSK   BITS(PIS_CH7_CON_MSIGS_POSS,PIS_CH7_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH_OER register ************************/

#define PIS_CH_OER_CH7OE_POS    7U
#define PIS_CH_OER_CH7OE_MSK    BIT(PIS_CH_OER_CH7OE_POS)

#define PIS_CH_OER_CH6OE_POS    6U
#define PIS_CH_OER_CH6OE_MSK    BIT(PIS_CH_OER_CH6OE_POS)

#define PIS_CH_OER_CH5OE_POS    5U
#define PIS_CH_OER_CH5OE_MSK    BIT(PIS_CH_OER_CH5OE_POS)

#define PIS_CH_OER_CH4OE_POS    4U
#define PIS_CH_OER_CH4OE_MSK    BIT(PIS_CH_OER_CH4OE_POS)

#define PIS_CH_OER_CH3OE_POS    3U
#define PIS_CH_OER_CH3OE_MSK    BIT(PIS_CH_OER_CH3OE_POS)

#define PIS_CH_OER_CH2OE_POS    2U
#define PIS_CH_OER_CH2OE_MSK    BIT(PIS_CH_OER_CH2OE_POS)

#define PIS_CH_OER_CH1OE_POS    1U
#define PIS_CH_OER_CH1OE_MSK    BIT(PIS_CH_OER_CH1OE_POS)

#define PIS_CH_OER_CH0OE_POS    0U
#define PIS_CH_OER_CH0OE_MSK    BIT(PIS_CH_OER_CH0OE_POS)

/****************** Bit definition for PIS_TAR_CON0 register ************************/

#define PIS_TAR_CON0_TIM3_ETRIN_SEL_POS 28U
#define PIS_TAR_CON0_TIM3_ETRIN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_ETRIN_SEL_POS)

#define PIS_TAR_CON0_TIM3_CH4IN_SEL_POS 27U
#define PIS_TAR_CON0_TIM3_CH4IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH4IN_SEL_POS)

#define PIS_TAR_CON0_TIM3_CH3IN_SEL_POS 26U
#define PIS_TAR_CON0_TIM3_CH3IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH3IN_SEL_POS)

#define PIS_TAR_CON0_TIM3_CH2IN_SEL_POS 25U
#define PIS_TAR_CON0_TIM3_CH2IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH2IN_SEL_POS)

#define PIS_TAR_CON0_TIM3_CH1IN_SEL_POS 24U
#define PIS_TAR_CON0_TIM3_CH1IN_SEL_MSK BIT(PIS_TAR_CON0_TIM3_CH1IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_ETRIN_SEL_POS 20U
#define PIS_TAR_CON0_TIM2_ETRIN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_ETRIN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH4IN_SEL_POS 19U
#define PIS_TAR_CON0_TIM2_CH4IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH4IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH3IN_SEL_POS 18U
#define PIS_TAR_CON0_TIM2_CH3IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH3IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH2IN_SEL_POS 17U
#define PIS_TAR_CON0_TIM2_CH2IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH2IN_SEL_POS)

#define PIS_TAR_CON0_TIM2_CH1IN_SEL_POS 16U
#define PIS_TAR_CON0_TIM2_CH1IN_SEL_MSK BIT(PIS_TAR_CON0_TIM2_CH1IN_SEL_POS)

#define PIS_TAR_CON0_TIM1_ETRIN_SEL_POS 12U
#define PIS_TAR_CON0_TIM1_ETRIN_SEL_MSK BIT(PIS_TAR_CON0_TIM1_ETRIN_SEL_POS)

#define PIS_TAR_CON0_TIM1_CH4IN_SEL_POS 11U
#define PIS_TAR_CON0_TIM1_CH4IN_SEL_MSK BIT(PIS_TAR_CON0_TIM1_CH4IN_SEL_POS)

#define PIS_TAR_CON0_TIM1_CH3IN_SEL_POS 10U
#define PIS_TAR_CON0_TIM1_CH3IN_SEL_MSK BIT(PIS_TAR_CON0_TIM1_CH3IN_SEL_POS)

#define PIS_TAR_CON0_TIM1_CH2IN_SEL_POS 9U
#define PIS_TAR_CON0_TIM1_CH2IN_SEL_MSK BIT(PIS_TAR_CON0_TIM1_CH2IN_SEL_POS)

#define PIS_TAR_CON0_TIM1_CH1IN_SEL_POS 8U
#define PIS_TAR_CON0_TIM1_CH1IN_SEL_MSK BIT(PIS_TAR_CON0_TIM1_CH1IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_ETRIN_SEL_POS 5U
#define PIS_TAR_CON0_TIM0_ETRIN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_ETRIN_SEL_POS)

#define PIS_TAR_CON0_TIM0_BRKIN_SEL_POS 4U
#define PIS_TAR_CON0_TIM0_BRKIN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_BRKIN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH4IN_SEL_POS 3U
#define PIS_TAR_CON0_TIM0_CH4IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH4IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH3IN_SEL_POS 2U
#define PIS_TAR_CON0_TIM0_CH3IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH3IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH2IN_SEL_POS 1U
#define PIS_TAR_CON0_TIM0_CH2IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH2IN_SEL_POS)

#define PIS_TAR_CON0_TIM0_CH1IN_SEL_POS 0U
#define PIS_TAR_CON0_TIM0_CH1IN_SEL_MSK BIT(PIS_TAR_CON0_TIM0_CH1IN_SEL_POS)

/****************** Bit definition for PIS_TAR_CON1 register ************************/

#define PIS_TAR_CON1_SPI1_CLK_SEL_POS   15U
#define PIS_TAR_CON1_SPI1_CLK_SEL_MSK   BIT(PIS_TAR_CON1_SPI1_CLK_SEL_POS)

#define PIS_TAR_CON1_SPI1_RX_SEL_POS    14U
#define PIS_TAR_CON1_SPI1_RX_SEL_MSK    BIT(PIS_TAR_CON1_SPI1_RX_SEL_POS)

#define PIS_TAR_CON1_SPI0_CLK_SEL_POS   13U
#define PIS_TAR_CON1_SPI0_CLK_SEL_MSK   BIT(PIS_TAR_CON1_SPI0_CLK_SEL_POS)

#define PIS_TAR_CON1_SPI0_RX_SEL_POS    12U
#define PIS_TAR_CON1_SPI0_RX_SEL_MSK    BIT(PIS_TAR_CON1_SPI0_RX_SEL_POS)

#define PIS_TAR_CON1_UART4_RXD_SEL_POS  4U
#define PIS_TAR_CON1_UART4_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART4_RXD_SEL_POS)

#define PIS_TAR_CON1_UART3_RXD_SEL_POS  3U
#define PIS_TAR_CON1_UART3_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART3_RXD_SEL_POS)

#define PIS_TAR_CON1_UART2_RXD_SEL_POS  2U
#define PIS_TAR_CON1_UART2_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART2_RXD_SEL_POS)

#define PIS_TAR_CON1_UART1_RXD_SEL_POS  1U
#define PIS_TAR_CON1_UART1_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART1_RXD_SEL_POS)

#define PIS_TAR_CON1_UART0_RXD_SEL_POS  0U
#define PIS_TAR_CON1_UART0_RXD_SEL_MSK  BIT(PIS_TAR_CON1_UART0_RXD_SEL_POS)

/****************** Bit definition for PIS_UART0_TXMCR register ************************/

#define PIS_UART0_TXMCR_TXMLVLS_POS 8U
#define PIS_UART0_TXMCR_TXMLVLS_MSK BIT(PIS_UART0_TXMCR_TXMLVLS_POS)

#define PIS_UART0_TXMCR_TXMSS_POSS  4U
#define PIS_UART0_TXMCR_TXMSS_POSE  7U
#define PIS_UART0_TXMCR_TXMSS_MSK   BITS(PIS_UART0_TXMCR_TXMSS_POSS,PIS_UART0_TXMCR_TXMSS_POSE)

#define PIS_UART0_TXMCR_TXSIGS_POSS 0U
#define PIS_UART0_TXMCR_TXSIGS_POSE 3U
#define PIS_UART0_TXMCR_TXSIGS_MSK  BITS(PIS_UART0_TXMCR_TXSIGS_POSS,PIS_UART0_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART1_TXMCR register ************************/

#define PIS_UART1_TXMCR_TXMLVLS_POS 8U
#define PIS_UART1_TXMCR_TXMLVLS_MSK BIT(PIS_UART1_TXMCR_TXMLVLS_POS)

#define PIS_UART1_TXMCR_TXMSS_POSS  4U
#define PIS_UART1_TXMCR_TXMSS_POSE  7U
#define PIS_UART1_TXMCR_TXMSS_MSK   BITS(PIS_UART1_TXMCR_TXMSS_POSS,PIS_UART1_TXMCR_TXMSS_POSE)

#define PIS_UART1_TXMCR_TXSIGS_POSS 0U
#define PIS_UART1_TXMCR_TXSIGS_POSE 3U
#define PIS_UART1_TXMCR_TXSIGS_MSK  BITS(PIS_UART1_TXMCR_TXSIGS_POSS,PIS_UART1_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART2_TXMCR register ************************/

#define PIS_UART2_TXMCR_TXMLVLS_POS 8U
#define PIS_UART2_TXMCR_TXMLVLS_MSK BIT(PIS_UART2_TXMCR_TXMLVLS_POS)

#define PIS_UART2_TXMCR_TXMSS_POSS  4U
#define PIS_UART2_TXMCR_TXMSS_POSE  7U
#define PIS_UART2_TXMCR_TXMSS_MSK   BITS(PIS_UART2_TXMCR_TXMSS_POSS,PIS_UART2_TXMCR_TXMSS_POSE)

#define PIS_UART2_TXMCR_TXSIGS_POSS 0U
#define PIS_UART2_TXMCR_TXSIGS_POSE 3U
#define PIS_UART2_TXMCR_TXSIGS_MSK  BITS(PIS_UART2_TXMCR_TXSIGS_POSS,PIS_UART2_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART3_TXMCR register ************************/

#define PIS_UART3_TXMCR_TXMLVLS_POS 8U
#define PIS_UART3_TXMCR_TXMLVLS_MSK BIT(PIS_UART3_TXMCR_TXMLVLS_POS)

#define PIS_UART3_TXMCR_TXMSS_POSS  4U
#define PIS_UART3_TXMCR_TXMSS_POSE  7U
#define PIS_UART3_TXMCR_TXMSS_MSK   BITS(PIS_UART3_TXMCR_TXMSS_POSS,PIS_UART3_TXMCR_TXMSS_POSE)

#define PIS_UART3_TXMCR_TXSIGS_POSS 0U
#define PIS_UART3_TXMCR_TXSIGS_POSE 3U
#define PIS_UART3_TXMCR_TXSIGS_MSK  BITS(PIS_UART3_TXMCR_TXSIGS_POSS,PIS_UART3_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_UART4_TXMCR register ************************/

#define PIS_UART4_TXMCR_TXMLVLS_POS 8U
#define PIS_UART4_TXMCR_TXMLVLS_MSK BIT(PIS_UART4_TXMCR_TXMLVLS_POS)

#define PIS_UART4_TXMCR_TXMSS_POSS  4U
#define PIS_UART4_TXMCR_TXMSS_POSE  7U
#define PIS_UART4_TXMCR_TXMSS_MSK   BITS(PIS_UART4_TXMCR_TXMSS_POSS,PIS_UART4_TXMCR_TXMSS_POSE)

#define PIS_UART4_TXMCR_TXSIGS_POSS 0U
#define PIS_UART4_TXMCR_TXSIGS_POSE 3U
#define PIS_UART4_TXMCR_TXSIGS_MSK  BITS(PIS_UART4_TXMCR_TXSIGS_POSS,PIS_UART4_TXMCR_TXSIGS_POSE)

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t CH_CON[8];
    uint32_t RESERVED0[8] ;
    __IO uint32_t CH_OER;
    __IO uint32_t TAR_CON0;
    __IO uint32_t TAR_CON1;
    uint32_t RESERVED1[5] ;
    __IO uint32_t UART0_TXMCR;
    __IO uint32_t UART1_TXMCR;
    __IO uint32_t UART2_TXMCR;
    __IO uint32_t UART3_TXMCR;
    __IO uint32_t UART4_TXMCR;
} PIS_TypeDef;

#endif /* __REG_PIS_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/