/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	uart.c
*  :	AE Team
*  :	V1.1
*  :	2024/10/18
*  :	TKڵӳ
*  ע:    ESD-TKT-7P2124-Button 
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

#if TK_UART_FUNC == ON

uchar rst_flag;
uchar Cnt_Mask;
uchar g_com;				//
uchar g_length;				//ݳ
uchar g_rp;					//ָ
uchar g_tp;					//ָ
uchar g_checksum;			//У
uchar Tx_timer;
//uchar UploadSampByte[(TK_NUM*2) + 5];		//ֽ
//uchar UploadRawByte[(TK_NUM*2)+5];		//˲ֽ
//uchar UploadBaseByte[(TK_NUM*2)+5];		//ֽ
uchar UploadBuf[(TK_NUM*2) + 5];	        //ͻ

/*********************************************************
:	void uart_init(void)
  :	UARTʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void uart_init(void)
{
	#if TK_UART_PORT == PE67
	PES7 = 0;
	PES6 = 0;
	PET7 = 0;	//UART_TXΪ
	PET6 = 1;	//UART_RXΪ
	PEPU6 = 1;
	#elif TK_UART_PORT == PB7E0
	PBS7 = 0;
	PES0 = 0;
	PSFT3 = 1;  //UART ӳPB7 PE0
	PBT7  = 0;	//UART_TXΪ
	PET0  = 1;	//UART_RXΪ
	PEPU0 = 1;
	#endif
	TX0LEN = 0;	//8λݸʽ
	RX0LEN = 0;
	BRGH0 = 1;	//ģʽ
	#if TK_UART_BAUD == 115200
	BR0R = 8;	//115200bps=Fosc/(16(BRR<7:0> + 1))@16MHz
	#elif TK_UART_BAUD == 57600
	BR0R = 16;	//57600bps=Fosc/(16(BRR<7:0> + 1))@16MHz
	#elif TK_UART_BAUD == 56000
	BR0R = 17;	//56000bps=Fosc/(16(BRR<7:0> + 1))@16MHz
	#elif TK_UART_BAUD == 38400
	BR0R = 25;	//38400bps=Fosc/(16(BRR<7:0> + 1))@16MHz
	#elif TK_UART_BAUD == 19200
	BR0R = 51;	//19200bps=Fosc/(16(BRR<7:0> + 1))@16MHz
	#elif TK_UART_BAUD == 9600
	BR0R = 103;	//9600bps=Fosc/(16(BRR<7:0> + 1))@16MHz
	#elif TK_UART_BAUD == 4800
	BR0R = 207;	//4800bps=Fosc/(16(BRR<7:0> + 1))@16MHz
	#endif
	RX0EN = 1;	//UARTʹ
	RX0IE = 1;	//ʹUARTж

	TX0EN = 1;	//UARTʹ
	TX0IE = 0;	//ֹUARTжϣҪʱʹ

	RX0IF = 0;
	TX0IF = 0;
	g_tp = 0;
}

/*********************************************************
:	void tk_uart_isr_handler(void)
  :	UARTʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void tk_uart_isr_handler(void)
{
	uchar i;
	tk_arr_t * ptr;   
	if(RX0IE && RX0IF)			//UARTж	
	{  
		g_com = RX0B;			//UARTݼĴͬʱӲRXIF־  
		UploadBuf[0] = 0x68;
		UploadBuf[1] = 0x68;
		g_rp = 0;			 //ָ0
		Cnt_Mask = 0;
		g_checksum = 0;		 //У0
		if(g_tp == 0)        //ڷ״̬
		{
			if(g_com == COMMOND1)
			{
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2];	//Уͣۼֵ
#if TK_Lowpowermode == ON
				if(g_wakeup_flag == 0)
				{
					while(Cnt_Mask < (TK_NUM*2))
					{
						if(((long)0x00000001 << (Cnt_Mask/2)))
						{
							UploadBuf[g_rp + 4] = 0;					
							g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
							g_rp++;
							Cnt_Mask++;
						}
						else
						{
							Cnt_Mask++;
						}
					}
				}
				else
#endif
				{
					while(Cnt_Mask < (TK_NUM*2))
					{
						if(((long)0x00000001 << (Cnt_Mask/2)))
						{
							UploadBuf[g_rp + 4] = 0;//UploadSampByte[Cnt_Mask];					
							g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
							g_rp++;
							Cnt_Mask++;
						}
						else
						{
							Cnt_Mask++;
						}
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND2)
			{
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
#if TK_Lowpowermode == ON					
				if(g_wakeup_flag == 0)
				{
					for(i = 0;i < TK_NUM; i++)
					{
						UploadBuf[4+(i*2)] = (uchar)(TK_md2value_origin[i]>>8);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						UploadBuf[4+(i*2) + 1] = (uchar)(TK_md2value_origin[i]);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
					}
				}
				else
#endif
				{
					for(i = 0; i < TK_NUM; i++)
					{
						ptr = &tk_arr[i];
						UploadBuf[4 + (i*2)] = (uchar)(ptr->tk_filter>>8);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
						UploadBuf[4 + (i*2) + 1] = (uchar)(ptr->tk_filter);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND3)
			{				
				UploadBuf[2] = g_com;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
					
#if TK_Lowpowermode == ON
				if(g_wakeup_flag == 0)
				{
					for(i = 0; i < TK_NUM; i++)
					{
						UploadBuf[4+(i*2)] = (uchar)(TK_md2average_backup[i]>>8);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						UploadBuf[4+(i*2) +1] = (uchar)(TK_md2average_backup[i]);
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
					}					
				}
				else
#endif
				{
					for(i = 0; i < TK_NUM; i++)
					{
						ptr = &tk_arr[i];
						UploadBuf[4 + (i*2)] = (uchar)(ptr->tk_avg>>8);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
						UploadBuf[4 + (i*2) + 1] = (uchar)(ptr->tk_avg);
						g_checksum += UploadBuf[g_rp + 4];	//Уͣۼֵ
						g_rp++;
					}
				}

				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
#if TK_Lowpowermode == ON
				if(uart_send_flag)
				{
					uart_send_flag++;					
				}
#endif
			}
			else if(g_com == COMMOND4)  //ֵ
			{
				UploadBuf[2] = g_com;
				g_length = 9;
				UploadBuf[3] = 9;

				UploadBuf[4] = (uchar)(0);	     //Mode
				//#if  TK_Singlepress == ON  
				//UploadBuf[5] = (uchar)(TK_state_single>>16); //ֵH
				//UploadBuf[6] = (uchar)(TK_state_single>>8);	 //ֵM
				//UploadBuf[7] = (uchar)(TK_state_single);	 //ֵL
				//#else
				UploadBuf[5] = (uchar)(tk_state>>16);    //ֵH
				UploadBuf[6] = (uchar)(tk_state>>8);	 //ֵM
				UploadBuf[7] = (uchar)(tk_state);		 //ֵL
				//#endif

				#if  TK_Slider_Function == ON  
				UploadBuf[8] = (uchar)(TK_slider_value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_slider_value);       //Byte L
				#elif TK_JITTER_DEBUG == ON
				UploadBuf[8] = (uchar)(TK_jitter_Value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_jitter_Value);       //Byte L
				#else
				UploadBuf[8] = 0;		//Byte H
				UploadBuf[9] = 0;       //Byte L				
				#endif

				#if  TK_Wheel_Function == ON  
				UploadBuf[10] = (uchar)(TK_wheel_value>>8);    //Byte H
				UploadBuf[11] = (uchar)(TK_wheel_value);       //Byte L
				#else
				UploadBuf[10] = 0;
				UploadBuf[11] = 0;
				#endif

				#if  TK_Matrix_Function == ON  
				UploadBuf[12] = TK_Matrix_value ;              //Byte 			
				#else			
				UploadBuf[12] = 0;
				#endif
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3] + UploadBuf[4] + UploadBuf[5];	//Уͣۼֵ
				g_checksum += UploadBuf[6] + UploadBuf[7] + UploadBuf[8] + UploadBuf[9] + UploadBuf[10] + UploadBuf[11]+ UploadBuf[12];	//Уͣۼֵ
				UploadBuf[13] = g_checksum;
				TX0B = UploadBuf[0];	//дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND0)  //ͨ
			{
				UploadBuf[2] = g_com;
				g_length     = 1;
				UploadBuf[3] = 1;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ				
				UploadBuf[4] = TK_NUM;
				g_checksum += UploadBuf[4];	                                                //Уͣۼֵ
				g_rp++;								
				UploadBuf[g_rp + 4] = g_checksum;
				TX0B = UploadBuf[0];	    //дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND5)  //оƬλ
			{
				UploadBuf[2] = g_com;
			    g_length     = 2;
				UploadBuf[3] = 1;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ						
				UploadBuf[4] = 0xAA;
				g_checksum += UploadBuf[4];	                                                //Уͣۼֵ
				g_rp++;								
				UploadBuf[g_rp+4] = g_checksum;
				TX0B = UploadBuf[0];	    //дͻ
				g_tp = 1;
				TX0IE = 1;				//ʹTXж 
				rst_flag = 1;	
			}
			else
			{
				//temp = ((g_com & 0xF0) >> 4 ) -6;
				//ChannelMask &= ~(0x0000000F << (temp*4));
				//ChannelMask |= ((g_com & 0x0F) << (temp*4));
				//g_length     = 0;
				//UploadBuf[3] = 0;
				//g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ	
				//g_rp ++;								
				//UploadBuf[4] = g_checksum;
				//TX0B = UploadBuf[0];	    //дͻ
				//g_tp =1;
				//TX0IE = 1;				//ʹTXж 
			}
		}					
		else
		{
			if(Tx_timer == 0)
			{
				Tx_timer = 1;
			}
		}
	}	

	if(TX0IE && TX0IF)				//UARTж  
	{	
		if(g_tp < g_length + 5)
		{
			TX0B = UploadBuf[g_tp];	//дͻ
			g_tp++; 
		}
		else
		{
			g_tp = 0;				//ָ0
			TX0IE = 0;				//ֹTXж 	
			Tx_timer = 0;           //巢ͼʱ
			g_length = 0;
#if TK_Lowpowermode == ON
			if(uart_send_flag > 2)
			{
				uart_send_flag = 4;
			}
#endif
			if(rst_flag)
			{
				rst_flag = 0;
				rst();
			}
		}
	}
}

#endif
