#include  <hic.h>
#include  <string.h>
#include  "typedef.h"
#include  "macrodef.h"
#include  "rw_flash.h"

/**********************************************
check_empty
  ѯFlashǷΪ
ֵword_addr:Flashʼַ;num:յֽ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 check_empty(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i, buf16;

    for (i = 0; i < (num / 2); i++)
    {
        if (i % 2 == 1)
        {

            __Asm  TBR;

            buf16 = (((u16)ROMD1H << 8) + ROMD1L);
            ++word_addr;
            buf_Addr += 2;
        }

        if (i % 2 == 0)
        {
            FRAL = word_addr;
            FRAH = word_addr >> 8;
            FRAHN = ~FRAH;
            FRALN = ~FRAL;
            __Asm  TBR;
            buf16 = (((u16)ROMDH << 8) + ROMDL);
            ++word_addr;
            buf_Addr += 2;
        }

        if (buf16 != 0xFFFF)
        {
            return  FAILED;
        }
    }

    return  SUCCESS;
}
/**********************************************
Read_Cont
  Flash
ֵword_addr:Flashַ; *buf_Addr:ݱַ; num:ֽ
ֵFlashе
ֵSUCCESSFAILED
**********************************************/
u8 Read_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;

    for (i = 0; i < (num / 2); i++)
    {
        if (i % 2 == 1)
        {
            __Asm  TBR;
            *(u16 *)buf_Addr = (((u16)ROMD1H << 8) + ROMD1L);
            word_addr++;
            buf_Addr += 2;
        }

        if (i % 2 == 0)
        {
            FRAL = word_addr;
            FRAH = word_addr >> 8;
            FRAHN = ~FRAH;
            FRALN = ~FRAL;
            __Asm  TBR;
            *(u16 *)buf_Addr = (((u16)ROMDH << 8) + ROMDL);
            word_addr++;
            buf_Addr += 2;
        }
    }

    ROMCL = 0x00;
    return  SUCCESS;
}

static volatile unsigned int section8 FRAN @ 0xFF8E;
static volatile unsigned int section8 FRA  @ 0xFF90;
/**********************************************
StartIAP
  IAP̶
ֵ
ֵ
ֵ
**********************************************/
void StartIAP(void) //IAP̶ʽ
{
    __asm
    {
        MOVI 0x55
        MOVA ROMCH
        MOVI 0x02        //ȴ8ָ
        SSUBI 1          //(A)-1->(A)
        JBS PSW, Z
        goto $-2
        MOVI 0xAA
        MOVA ROMCH
        MOVI 0x02        //ȴ8->(ָ
        SSUBI 1          //(A)-1A)
        JBS PSW, Z
        goto $-2
        BSS ROMCL, WR    //Flash洢ҳ/Ա̴λ
        JBC ROMCL, WR
        goto $-1         //ȴ
    }
}
/**********************************************
Erase_Page
  һҳFlash
ֵpage_addrҳڵĵַ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Erase_Page(u16  page_addr)
{
    GIE = 0 ;
    DATARDEN = 1;
    FPEE = 1;
    FRAH = page_addr >> 8;  //ַֽ
    FRAL = page_addr;       //ַֽ
    FRAHN = ~FRAH;
    FRALN = ~FRAL;
    WREN = 1;
    StartIAP();
    //while(WR);    //ȴ
    ROMCL = 0x00;
    FRA = 0xFF12;   //ָõĵַռ
    FRAN = 0x3456;  //˴ѵַ븳0xFFFFFRAȡϵֵ
    return SUCCESS;
}
/**********************************************
Write_Cont
  Flashд
ֵword_addrFlashʼַ;buf_Addr:Ҫдݵʼַ num:ݸ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Write_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;

    GIE = 0;
    ROMCL = 0x80;
    DATARDEN = 1;
    FPEE = 0;

    for (i = 0; i < (num / 4); i++) //ÿд˫(32bit)
    {
        FRAH = word_addr >> 8;  //ַֽ
        FRAL = word_addr;       //ַֽ
        FRAHN = ~FRAH;
        FRALN = ~FRAL;
        ROMD1H = (*((u32 *)buf_Addr)) >> 24;
        ROMD1L = (*((u32 *)buf_Addr)) >> 16;
        ROMDH = (*((u32 *)buf_Addr)) >> 8;
        ROMDL = (*((u32 *)buf_Addr));    //дFlashֽ
        WREN = 1;
        StartIAP();
        word_addr += 2;
        buf_Addr += 4;
    }

    ROMCL = 0x00;
    FRA = 0xFF12;//ָõĵַռ
    FRAN = 0x3456;//˴ѵַ븳0xFFFFFRAȡϵֵ
    ROMDH = 0xFF;//ݳʼΪ0xFF
    ROMDL = 0xFF;//ݳʼΪ0xFF
    ROMD1H = 0xFF;//ݳʼΪ0xFF
    ROMD1L = 0xFF;//ݳʼΪ0xFF
    return  SUCCESS;
}


