#include  <hic.h>
#include  "typedef.h"
#include  "macrodef.h"
#include  "sysinit.h"

/**********************************************
Init_I2C
  I2Cʼ
ֵ
ֵ
ֵ
**********************************************/

void  Init_Uart(void)
{
    PAT1 = 0; //TX
    PAT2 = 1; //RX
    ANSL |= 3 << 1; //ֿ
    RX0LEN = 0;
    TX0LEN = 0;
    BRGH0 = 1;
    BR0R = 103; //9600
    RX0EN = 1;
    TX0EN = 1;
}
void  Init_I2C(void)
{
    PBT |= 0x03;
    //PB&=0xFC;
    PBT0 = 1;       //SDA˿Ϊ
    PBT1 = 1;       //SCL˿Ϊ
    ANSL |= 1 << 3; //PB0ֿ
    ANSH |= 1 << 3; //PB1ֿ
    I2CRST = 1;         //λI2C

    while (I2CRST);     //ȴλ

    //I2CANAE = 1;
    I2CC = 0xE0;        //I2C©ACK;
    I2CSA = SLAVE_ADDR << 1;    //ӻַ
    I2CEN = 1;          //ʹI2C
}
/**********************************************
Init_Timer
  ʱʼ
ֵ
ֵ
ֵ
**********************************************/
void  Init_Timer(void)
{
    T8NC = 0x0E; //Ƶϵ1:128
    T8N = 0;
    T8NIE = 0;  //ʹж
    T8NEN = 1;
}
/**********************************************
Init_Ports
  ˿ڳʼ
ֵ
ֵ
ֵ
**********************************************/
void  Init_Ports(void)
{
    PAT0 = 1;
    ANSL0 = 1;
    PAPD0 = 1;  //BOOTPIN
}
/**********************************************
Reg_reset
  Ĵλ
ֵ
ֵ
ֵ
**********************************************/
void Reg_reset(void)
{
    PAT0 = 0xFF;
    PBT0 = 0xFF;
    ANSL = 0;
    ANSH = 0;

    T8NC = 0;
    T8NEN = 0;

    I2CEN = 0;
}
/**********************************************
Init_MCU
  ܳʼ
ֵ
ֵ
ֵ
**********************************************/
void Init_MCU(void)
{
    Init_Ports();
    Init_I2C();
    Init_Timer();
}