/*********************************************************
*Copyright (C), 2020, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  uart.c
*  :  AE Team
*  :  v1.0iDesigner(v4.2.3.166) + HRCC(v1.2.0.106)
*  :  2020/07/07
*  :  UARTͨʾ
          PB5TX
          PB6RX
          λͨţ9600λһ"www.essemi.com"Ȼѭյԭء
          ͨ궨ķʽѡòѯͽջѡжϷʽͽա
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define IT_SR       //жϷͽգעʹ˺궨ʹòѯʽͽ
#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

unsigned char rxbuf;
unsigned char str[] = "www.essemi.com\0";

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH = 0; IAAH <= 0x03; IAAH++)
    {
        for (IAAL = 0; IAAL < 0xFF; IAAL++)
            IAD = 0x00;

        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    ANSH = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

/**********************************************
void main(void)
  
ֵ
ֵ
ֵ
**********************************************/
void main(void)
{
    unsigned char *ptr = str;
//    RAMclear();
    GPIOInit();
    PBT5 = 0;       //TX
    PBT6 = 1;       //RX
    RX1LEN = 0;     //8λݽոʽ
    TX1LEN = 0;     //8λݷ͸ʽ
    BRGH1 = 0;      //ʵģʽ=Fosc/(64*(BRR<7:0>+1))
    BR1R = 0x19;    //=16MHz/(64*(25+1))9600bps

#ifdef IT_SR
    RX1IE = 1;       //ж
    GIE = 1;        //ж
#endif
    RX1EN = 1;       //򿪽
    TX1EN = 1;       //򿪷

    while (*ptr)        //ͣ"www.essemi.com"
    {
        while (!TRMT1);

        TX1B = *(ptr++);
        CLRWDT();
    }

    while (1)
    {
#ifndef IT_SR           //ѯʽͽ

        if (RXIF == 1)
        {
            rxbuf = RX1B;

            while (!TRMT1);

            TX1B = rxbuf;
        }

#endif
        CLRWDT();
    }
}

/**********************************************
void isr(void) interrupt
  жϷ
ֵ
ֵ
ֵ
**********************************************/
#ifdef IT_SR
void isr(void) interrupt
{
    if (RX1IE == 1 && RX1IF == 1)
    {
        rxbuf = RX1B;

        while (!TRMT1);

        TX1B = rxbuf;
    }
}
#endif