/*******************************************************
*Copyright(C),2020,Shanghai Eastsoft Microelectronics Co.,Ltd.
*ļvector.c
*  ߣAE Team
*  v1.0iDesigner(v4.2.3.166) + HRCC(v1.2.0.106)
*  ڣ2020/07/10
*  ʹжģʽǰֽѡ->жģʽҼ->->->Support interrupt vectors->True
        ɺмǱãINTV<1:0>INTPĴãӦȼжϡȼжϿǶӦȼжϣ
        ͬ()ȼж֮䲻ǶӦ
*  עѧϰʾʹãûֱôķջеκηΡ
*******************************************************/
#include <hic.h>

#define SLAVE_ADDR  0x2D            //궨IICӻַ
#define I2C_RLENGTH 64
#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

unsigned char t8nisr;        //T8Nжϼƴα־
unsigned char i2c_sta, i2c_rxd[I2C_RLENGTH], i2c_temp;    //I2C/״̬
unsigned char uart_rxd;

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH = 0; IAAH <= 0x03; IAAH++)
    {
        for (IAAL = 0; IAAL < 0xFF; IAAL++)
            IAD = 0x00;

        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    ANSH = 0xFF;
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

/*******************************************************
void isrx(void) interrupt
  жϷisrxӦIGx
ֵ
ֵ
ֵ
*******************************************************/
void isr0(void) interrupt_low 0x24        //IG0(T8N)1sʱж
{
    T8N = 6;          //ֵ
    t8nisr++;

    if (t8nisr >= 250)      //1sʱ
    {
        t8nisr = 0;
        PA4 = ~PA4;
    }

    T8NIF = 0;        //־λ
}

void isr3(void) interrupt_high 0x18        //IG3(UART)ж
{
    if (RX0IE == 1 && RX0IF == 1) //UARTжϣݷ
    {
        uart_rxd = RX0B;
        TX0B = uart_rxd;
    }

    if (TX0IE == 1 && TX0IF == 1) //UARTжϣд
    {
        TX0B = 0x5A;     //ʾ
        TX0IE = 0;       //ʾ
    }
}

void isr6(void) interrupt_high 0x0C        //IG6(I2C)ж
{
    if (I2CRBIE == 1 && I2CRBIF == 1)      //I2Cж
    {
        i2c_rxd[i2c_temp] = I2CRB;        //I2Cݷ
        I2CTB = i2c_rxd[i2c_temp];
        i2c_temp++;

        if (i2c_temp > I2C_RLENGTH)
            i2c_temp = 0;
    }

    if (I2CSRIE == 1 && I2CSRIF == 1)   //I2Cաʼλ+ӻַƥ+Ӧλж
    {
        i2c_sta = 1;        //I2C/״̬
        I2CSRIF = 0;
    }

    I2CIF = 0;      //I2Cܱ־λ
}

void isr7(void) interrupt_low 0x08         //IG7(T21)1sʱж
{
    if (T21VIE == 1 && T21VIF == 1)     //ʱж
    {
        PA6 = ~PA6;
        T21VIF = 0;        //־λ
    }
}

/*******************************************************
void main(void)
  ĬжIG6IG3ΪȼжϣIG0IG7Ϊȼж
        ȼ˳IG6()>IG3()>IG0()>IG7()ȼǶӦȼ
ֵ
ֵ
ֵ
*******************************************************/
void main(void)
{
    RAMclear();
    GPIOInit();
    i2c_temp = 0;
    INTG = 0x07;        //жģʽжINTV<1:0>=11
    IGP6 = 1;           //I2Cжϸȼ
    IGP3 = 1;           //UARTжϸȼ

    /**********************T8Nʼ************************/
    T8NC = 0x0E;         //ʱģʽԤƵ1:(Fosc/2)/128
    T8N = 6;             //ֵ4ms
    T8NIF = 0;           //־λ
    T8NIE = 1;           //򿪶ʱж

    /**********************T21ʼ************************/
    T21CL = 0x00;        //ʱģʽ
    T21CM = 0x0F;        //ԤƵ1:16
    T21CH = 0x0F;        //Ƶ16
    T21PH = 0xF4;        //ֵ8λ
    T21PL = 0x24;
    T21VIF = 0;          //־λ
    T21VIE = 1;          //T21ж

    /**********************IICʼ************************/
    PBT0 = 1;           //I2C_SDA
    PBT1 = 1;           //I2C_SCL
    I2CC = 0xE0;        //I2C˿ʹܣʹ©ʽACK
    I2CSA = SLAVE_ADDR << 1;    //ӻַ
    I2CIFC = 0x00;      //־λ
    I2CRBIE = 1;        //ʹI2Cж
    I2CIF = 0;          //I2Cܱ־λ
    I2CIE = 1;          //ʹI2Cж

    /**********************UARTʼ***********************/
    PAT1 = 0;       //TX
    PAT2 = 1;       //RX
    RX0LEN = 0;     //8λݽոʽ
    TX0LEN = 0;     //8λݷ͸ʽ
    BRGH0 = 0;      //ʵģʽ=Fosc/(64*(BRR<7:0>+1))
    BR0R = 25;      //=16MHz/(64*26)9600bps
    TX0IE = 1;      //Ϳж
    RX0IE = 1;      //ж

    /*****************ȫжϣʹģ*****************/
    GIEL = 1;           //ȼж
    GIE = 1;            //ȫж
    T8NEN = 1;          //ʹT8N
    T21EN = 1;          //ʹT21
    I2CEN = 1;          //ʹI2C
    RX0EN = 1;          //ʹUART
    TX0EN = 1;          //ʹUART

    while (1)
    {
        CLRWDT();
    }
}