/*****************************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  iap_flash.h
*  :  AE Team
*  :  2020/07/23
*  :  ͷļES7P0693
*  ע:  ʹãûֱôķջеκηΡ
******************************************************************/

#ifndef _ES7P0693_IAP_
#define _ES7P0693_IAP_

#include "ES7P0693.h"
#include <hic.h>

/* Ͷ */
typedef unsigned char  uchar;       //޷8λͱ
typedef unsigned int   uint;        //޷16λͱ
typedef unsigned long  ulong;       //޷32λͱ

typedef unsigned char  u8;          //޷8λͱ
typedef unsigned int   u16;         //޷16λͱ
typedef unsigned long  u32;         //޷32λͱ

typedef unsigned char  INT8U;       //޷8λͱ
typedef signed   char  INT8S;       //з8λͱ
typedef unsigned int   INT16U;      //޷16λͱ
typedef signed   int   INT16S;      //з16λͱ
typedef unsigned long  INT32U;      //޷32λͱ
typedef signed   long  INT32S;      //з32λͱ

typedef float          FP32;        //ȸͱ[floating-point type:]
typedef double         FP64;        //˫ȸͱ

/* 嶨 */
typedef union
{
    unsigned char byte;
    struct P8Bit
    {
        unsigned char bit0: 1;   // 1
        unsigned char bit1: 1;   // 2
        unsigned char bit2: 1;   // 3
        unsigned char bit3: 1;   // 4
        unsigned char bit4: 1;   // 5
        unsigned char bit5: 1;   // 6
        unsigned char bit6: 1;   // 7
        unsigned char bit7: 1;   // 8
    } bitn;
} BitAccess;

/* ָ궨 */
#define nop()       {__Asm NOP;}    //
#define clr_wdt()   {__Asm CWDT;}   //幷
#define IDLE()      {__Asm IDLE;}   //͹ģʽ
//#define TBR()     {__Asm TBR;}    //
#define TBR          __Asm TBR    //ָ

/* ־λ궨 */
#define FALSE       0
#define TRUE        1
#define WRONG       0
#define SUCCESS     1


//FRAH-PAGEѡ
#define CODEADDRH   0x3F        //CODEҳߵַ
//#define CODEADDRH 0x08

#define CODEADDRL   0x00

//FRAH-ѡ
#define CODE    0x00

#define WRDATA0H   0x55        //ROMD0дֽ(85)
#define WRDATA0L   0xAA        //ROMD0дֽ(170)
#define WRDATA1H   0x55        //ROMD1дֽ(85)
#define WRDATA1L   0xAA        //ROMD1дֽ(170)

#define ERASEDATA 0xFF        //ɺ(256)

#endif