/*******************************************************
*Copyright(C),2020,Shanghai Eastsoft Microelectronics Co.,Ltd.
*ļiap_flash.c
*  ߣAE Team
*  v1.1iDesigner(v4.2.3.166) + HRCC(v1.2.0.106)
*  ڣ2020/12/18
*  IAPʹFRENַ0x0000~0x1FFF0x0000~0x007FΪ1ҳ
         0x0080~0x00FFΪ2ҳ0x0100~0x017FΪ3ҳԴơ
         IAPҳ(256ַԪ)Ϊλһִַвǲַڵһҳ
         IAPдһַԪΪλ(һַԪӦһWord)ÿҳʱ2msַʱ25us
         IAPֹܷ
        ע⣺IAPǰرWDT(ѡWDTENΪDisable)ʹWDTúWDTʱ䣬幷
*  עѧϰʾʹãûֱôķջеκηΡ
*******************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}    //궨幷ָ

#define STARTADDR    0x1F00         //궨IAPʼַ
#define ENDADDR      0x1F7F         //궨IAPַ
#define WRDATA       0x12345678     //궨д

unsigned char dataerr = 0;      //0дȣ1д

unsigned char CallFlashEn, FlashEwEn; //

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH = 0; IAAH <= 0x03; IAAH++)
    {
        for (IAAL = 0; IAAL < 0xFF; IAAL++)
            IAD = 0x00;

        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSH = 0xFF;        //ѡӦ˿ΪIO
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

static volatile unsigned int section8 FRAN @ 0xFF8E;
static volatile unsigned int section8 FRA  @ 0xFF90;

/******************************************************
void StartIAP(void)
  ʼIAPע⣺IAP̶ʽʹʱɸı
ֵ
ֵ
ֵ
*******************************************************/
void StartIAP(void)
{
    __asm
    {
        MOVI 0x55
        MOVA ROMCH
        MOVI 0xFF     //8NOP俪ʼ
        SECSEL &FlashEwEn &% 0x80//ѡڵsection
        XOR &FlashEwEn &% 0x80, 0 //0xFF xor 0xAA = 0x55
        SECSEL &CallFlashEn &% 0x80//ѡڵsection
        XOR &CallFlashEn &% 0x80, 0 //CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
        JBS PSW, Z //Ϊ0x00ִȷһNOP
        GOTO $+3
        NOP//8NOP
        MOVI 0xAA
        MOVA ROMCH
        MOVI 0xFF     //8NOP俪ʼ
        SECSEL &FlashEwEn &% 0x80//ѡڵsection
        XOR &FlashEwEn &% 0x80, 0 //0xFF xor 0xAA = 0x55
        SECSEL &CallFlashEn &% 0x80//ѡڵsection
        XOR &CallFlashEn &% 0x80, 0 //CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
        JBS PSW, Z //Ϊ0x00ִȷһNOP
        GOTO $+3
        NOP//8NOP
        BSS ROMCL, WR    //̲
        JBC ROMCL, WR
        goto $-1         //ȴ
    }
}

/*******************************************************
void FlashErsPage(unsigned int addr)
  ַڵҳ(256 word)ַΧ0x0000~0x1FFF
ֵFlashַaddrFlashȡַaddri
ֵ
ֵ
*******************************************************/
void FlashErsPage(unsigned int addr, unsigned int addri)
{
    unsigned char gie_bk = GIE;     //GIE
    CLRWDT();

    while (GIE == 1)GIE = 0;           //IAPǰرȫж

    FlashEwEn = 0xAA;//

    FPEE = 1;           //洢ģʽ
    FRAH = addr >> 8;
    FRAL = addr;
    FRAHN = addri >> 8;    //IAP/ַ̱ȡ߼
    FRALN = addri;

    WREN = 1;           //ʹܲ/̹
    StartIAP();         //ʼIAP
    ROMCL = 0x00;       //˳IAP
    FRA = 0xFF12;   //ָõĵַռ
    FRAN = 0x3456;  //˴ѵַ븳0xFFFFFRAȡϵֵ
    CallFlashEn = 0;//
    FlashEwEn = 0;
    GIE = gie_bk;            //ָȫж
}

/*******************************************************
unsigned long FlashRdData(unsigned int addr)
  FlashַָݣַΧ0x0000~0x1FFF
ֵFlashַaddr
ֵ
ֵFlashַָ
*******************************************************/
unsigned long FlashRdData(unsigned int addr)
{
    unsigned long data;
    unsigned char gie_bk = GIE;     //GIE
    CLRWDT();

    while (GIE == 1)GIE = 0;           //IAPǰرȫж

    FRAH = addr >> 8;
    FRAL = addr;
    __Asm TBR;          //ָ
    data = ((unsigned long)ROMD1H << 24) | ((unsigned long)ROMD1L << 16) | ((unsigned long)ROMDH << 8) | ROMDL;
    GIE = gie_bk;            //ָȫж
    return data;
}

/*******************************************************
void FlashWrData(unsigned int addr, unsigned int word)
  дFlashַָݣַΧ0x0000~0x1FFF
ֵFlashַaddrFlashȡַaddriдword
ֵ
ֵ0:дʧܣ1:дɹ
*******************************************************/
unsigned char FlashWrData(unsigned int addr, unsigned int addri, unsigned long word)
{
    unsigned char rmdh, rmdl, rmd1h, rmd1l;   //ʱROMDHROMDLֵ
    unsigned char gie_bk = GIE;     //GIE
    unsigned int reault; 

    CLRWDT();

    while (GIE == 1)GIE = 0;           //IAPǰرȫж

    FlashEwEn = 0xAA;//

    FPEE = 0;           //洢ģʽ
    ROMD1H = word >> 24;  //дWord
    ROMD1L = word >> 16;
    ROMDH = word >> 8;
    ROMDL = word;
    FRAH = addr >> 8;   //IAP̵ַ
    FRAL = addr;
    FRAHN = addri >> 8;    //IAP/ַ̱ȡ߼
    FRALN = addri;

    WREN = 1;           //ʹܱ
    StartIAP();         //ʼIAP
    CallFlashEn = 0;//
    FlashEwEn = 0;
    rmdh = ROMDH++;
    rmdl = ROMDL++;
    rmd1h = ROMD1H++;
    rmd1l = ROMD1L++;
    __Asm TBR;          //ָ

    if (ROMDH == rmdh && ROMDL == rmdl && ROMD1H == rmd1h && ROMD1L == rmd1l)
    {
		reault = 1;
    }
	else
	{
		reault = 0;
	}
    ROMCL = 0x00;       //˳IAP
	FRA = 0xFF12;//ָõĵַռ
	FRAN = 0x3456;//˴ѵַ븳0xFFFFFRAȡϵֵ
	ROMDH = 0xFF;//ݳʼΪ0xFF
	ROMDL = 0xFF;//ݳʼΪ0xFF
	ROMD1H = 0xFF;//ݳʼΪ0xFF
	ROMD1L = 0xFF;//ݳʼΪ0xFF
	CallFlashEn = 0;//
	FlashEwEn = 0; 
	GIE = gie_bk;            //ָȫж

	return reault;
}

/*******************************************************
void main(void)
  IAPַ0000~1FFF
ֵ
ֵ
ֵ
*******************************************************/
void main(void)
{
    unsigned char i;
    unsigned int j;
    unsigned long codeflash;
    unsigned int flashaddr;     //ַflashд

    RAMclear();
    GPIOInit();
    CLRWDT();

    /************IAPҳΪλÿҳ256Word*******/
    flashaddr = STARTADDR;      //flashaddrַҳ
    j = (ENDADDR >> 8) - (STARTADDR >> 8) + 1; //ʼַͽַ֮Ҫҳ

    for (i = 0; i < j; i++)
    {
        CallFlashEn = 0x55;     //CallFlashEnֵ0x55ִв̲
        FlashErsPage(flashaddr, ~flashaddr);
        flashaddr += 0x80;     //һҳ
    }

    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    /******************IAPд벢У********************/
    for (flashaddr = STARTADDR; flashaddr <= ENDADDR; flashaddr += 2)
    {
        CallFlashEn = 0x55;     //CallFlashEnֵ0x55ִв̲
        i = FlashWrData(flashaddr, ~flashaddr, WRDATA);

        if (i != 1)
            dataerr = 1;        //У
    }

    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    /******************IAPУ(ʾ)********************/
    for (flashaddr = STARTADDR; flashaddr <= ENDADDR; flashaddr += 2)
    {
        codeflash = FlashRdData(flashaddr);

        if (codeflash != WRDATA)
            dataerr = 1;        //У
    }

    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    while (1)
    {
        CLRWDT();
    }
}