/*******************************************************
*Copyright(C),2020,Shanghai Eastsoft Microelectronics Co.,Ltd.
*ļiap_dataflash.c
*  ߣAE Team
*  v1.1iDesigner(v4.2.3.166) + HRCC(v1.2.0.106)
*  ڣ2020/12/18
*  IAPַ0xC000~0xC1FF
        IAPҳ(256ַԪ)Ϊλһִַвǲַڵһҳ
        IAPдһַԪΪλ(һַԪӦһWord)ÿҳʱ2msַʱ25us
        IAPֹܷ
        ע⣺IAPǰرWDT(ѡWDTENΪDisable)ʹWDTúWDTʱ䣬幷
*  עѧϰʾʹãûֱôķջеκηΡ
*******************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

#define STARTADDR    0xC000     //궨IAPʼַ
#define ENDADDR      0xC07F     //궨IAPַ
#define WRDATA       0x87654321     //궨д

unsigned char dataerr = 0;      //0дȣ1д

unsigned char CallFlashEn, FlashEwEn; //

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH = 0; IAAH <= 0x03; IAAH++)
    {
        for (IAAL = 0; IAAL < 0xFF; IAAL++)
            IAD = 0x00;

        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSH = 0xFF;        //ѡӦ˿ΪIO
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

static volatile unsigned int section8 FRAN @ 0xFF8E;
static volatile unsigned int section8 FRA  @ 0xFF90;

/******************************************************
void StartIAP(void)
  ʼIAPע⣺IAP̶ʽʹʱɸı
ֵ
ֵ
ֵ
*******************************************************/
void StartIAP(void)
{
    __asm
    {
        MOVI 0x55
        MOVA ROMCH
        MOVI 0xFF     //8NOP俪ʼ
        SECSEL &FlashEwEn &% 0x80//ѡڵsection
        XOR &FlashEwEn &% 0x80, 0 //0xFF xor 0xAA = 0x55
        SECSEL &CallFlashEn &% 0x80//ѡڵsection
        XOR &CallFlashEn &% 0x80, 0 //CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
        JBS PSW, Z //Ϊ0x00ִȷһNOP
        GOTO $+3
        NOP//8NOP
        MOVI 0xAA
        MOVA ROMCH
        MOVI 0xFF     //8NOP俪ʼ
        SECSEL &FlashEwEn &% 0x80//ѡڵsection
        XOR &FlashEwEn &% 0x80, 0 //0xFF xor 0xAA = 0x55
        SECSEL &CallFlashEn &% 0x80//ѡڵsection
        XOR &CallFlashEn &% 0x80, 0 //CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
        JBS PSW, Z //Ϊ0x00ִȷһNOP
        GOTO $+3
        NOP//8NOP
        BSS ROMCL, WR    //̲
        JBC ROMCL, WR
        goto $-1         //ȴ
    }
}

/*******************************************************
void DataFlashErsPage(void)
  DataFlashҳ(256 word)ַΧ0xC000~0xC1FF
ֵDataFlashַaddrDataFlashȡַaddri
ֵ
ֵ
*******************************************************/
void DataFlashErsPage(unsigned int addr, unsigned int addri)
{
    unsigned char gie_bk = GIE;     //GIE
    CLRWDT();

    while (GIE == 1)GIE = 0;           //IAPǰرȫж

    FlashEwEn = 0xAA;//

    FPEE = 1;           //洢ģʽ
    FRAH = addr >> 8;
    FRAL = addr;
    FRAHN = addri >> 8;    //IAP/ַ̱ȡ߼
    FRALN = addri;

    WREN = 1;           //ʹܲ/̹
    StartIAP();         //ʼIAP
    CallFlashEn = 0;//
    FlashEwEn = 0;
    ROMCL = 0x00;       //˳IAP
    FRA = 0xFF12;//ָõĵַռ
    FRAN = 0x3456;//˴ѵַ븳0xFFFFFRAȡϵֵ
    GIE = gie_bk;       //ָȫж
}

/*******************************************************
unsigned long DataFlashRdData(unsigned int addr)
  Flashַָ
ֵDataFlashַaddrַΧ0xC000~0xC1FF
ֵ
ֵDataFlashַָ
*******************************************************/
unsigned long DataFlashRdData(unsigned int addr)
{
    unsigned long data;
    unsigned char gie_bk = GIE;   //GIE
    CLRWDT();

    while (GIE == 1)GIE = 0;

    FRAL = addr;
    FRAH = addr >> 8;
    DATARDTRG = 1;

    while (DATARDTRG);

    DATARDEN = 1;       //DATAʹ
    __Asm TBR;          //ָ
    data = ((unsigned long)ROMD1H << 24) | ((unsigned long)ROMD1L << 16) | ((unsigned long)ROMDH << 8) | ROMDL;
    DATARDEN = 0;       //DATAֹ
    GIE = gie_bk;       //ָȫж
    return data;
}

/*******************************************************
void DataFlashWrData(unsigned int addr, unsigned long word)
  дDataFlashַָݣַΧ0xC000~0xC1FF
ֵDataFlashַaddrDataFlashȡַaddriдword
ֵ
ֵ0:дʧܣ1:дɹ
*******************************************************/
unsigned char DataFlashWrData(unsigned int addr, unsigned int addri, unsigned long word)
{
    unsigned char rmdh, rmdl, rmd1h, rmd1l;   //ʱROMDHROMDLֵ
    unsigned char gie_bk = GIE;   //GIE
    unsigned int reault; 
	
    CLRWDT();

    while (GIE == 1)GIE = 0;           //IAPǰرȫж

    FlashEwEn = 0xAA;//

    FPEE = 0;           //洢ģʽ
    ROMD1H = word >> 24;  //дWord
    ROMD1L = word >> 16;
    ROMDH = word >> 8;
    ROMDL = word;
    FRAH = addr >> 8;   //IAP̵ַ
    FRAL = addr;
    FRAHN = addri >> 8;    //IAP/ַ̱ȡ߼
    FRALN = addri;

    WREN = 1;           //ʹܱ
    StartIAP();         //ʼIAP
    CallFlashEn = 0;//
    FlashEwEn = 0;
    rmdh = ROMDH++;
    rmdl = ROMDL++;
    rmd1h = ROMD1H++;
    rmd1l = ROMD1L++;
    DATARDEN = 1;    //DATAʹ
    FRAH = addr >> 8;
    FRAL = addr;
    DATARDTRG = 1;   //DATA

    while (DATARDTRG);

    __Asm TBR;          //ָ

    if (ROMDH == rmdh && ROMDL == rmdl && ROMD1H == rmd1h && ROMD1L == rmd1l)
    {
		reault = 1;
    }
	else
	{
		reault = 0;
	}
    ROMCL = 0x00;       //˳IAP
	FRA = 0xFF12;//ָõĵַռ
	FRAN = 0x3456;//˴ѵַ븳0xFFFFFRAȡϵֵ
	ROMDH = 0xFF;//ݳʼΪ0xFF
	ROMDL = 0xFF;//ݳʼΪ0xFF
	ROMD1H = 0xFF;//ݳʼΪ0xFF
	ROMD1L = 0xFF;//ݳʼΪ0xFF
	CallFlashEn = 0;//
	FlashEwEn = 0; 
	GIE = gie_bk;            //ָȫж

	return reault;
}

/*******************************************************
void main(void)
  IAPַ0xC000~0xC1FF
ֵ
ֵ
ֵ
*******************************************************/
void main(void)
{
    unsigned char i;
    unsigned long j;
    unsigned int dtflashaddr;       //ַDataFlashд

    RAMclear();
    GPIOInit();

    /************IAPFlash(256Word)****/
    CallFlashEn = 0x55;         //CallFlashEnֵ0x55ִв̲
    DataFlashErsPage(STARTADDR, ~STARTADDR);
    CLRWDT();

    /******************IAPд벢У******************/
    for (dtflashaddr = STARTADDR; dtflashaddr <= ENDADDR; dtflashaddr++)
    {
        CallFlashEn = 0x55;     //CallFlashEnֵ0x55ִв̲
        i = DataFlashWrData(dtflashaddr, ~dtflashaddr, WRDATA);

        if (i != 1)
            dataerr = 1;        //У
    }

    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    /******************IAPУ(ʾ)******************/
    for (dtflashaddr = STARTADDR; dtflashaddr <= ENDADDR; dtflashaddr++)
    {
        j = DataFlashRdData(dtflashaddr);

        if (j != WRDATA)
            dataerr = 1;        //У
    }

    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    while (1)
    {
        CLRWDT();
    }
}